/*************************************************************
 *   Basic support classes, not really needed in all project *
 *   but used in this                                        *
 *************************************************************/

#include <irrlicht.h>
#include <windows.h>

using namespace irr;

typedef core::stringc stdstring;
typedef core::stringc String;

    //Define a class StringList based on irrlicht array and the defined class String
class StringList : public core::array<String>
{
   public:
    StringList()
	{
	}

    /**Constructor based on file loading.
    Look at LoadFromFile specifications.*/
	StringList(io::IReadFile* file)
	{
		LoadFromFile(file);
	}

    /**Basic destructor.*/
    ~StringList()
	{
		clear();
	}

    //Adds a String to StringList
    /** Add a string to this StringList.*/
    void Add(String str/*<String to add to the current StringList*/)
	{
		push_back(str);
	}

    //Loads a stringlist from a file
    //note that each String added to StringList
    //is separed by a \\n character and it's present
    //at the end of line.
    /** Loads a StringList from a file.
    This function loads a StringList from a file where each string is divided by a \\n char.*/
    void LoadFromFile(io::IReadFile* file)
	{
		int sz = file->getSize();
		char* buf = new char[sz+1];
		file->read(buf, sz);
		buf[sz] = 0;
		char* p = buf;
		char* start = p;

		while(*p)
		{
			if (*p == '\n')
			{
				core::stringc str(start, p - start - 1);
				str.trim();
				Add(str);
				start = p+1;
			}

			++p;
		}

		if (p - start > 1)
		{
			core::stringc str(start, p - start - 1);
			str.trim();
			Add(str);
		}

		delete [] buf;
    }


	//GetText returns a String containing all the text included in
    //the StringList
    /** Returns all strings contained in the StringList as a single string.
    \return A single String containing all items.*/
    String GetText()
	{
        String str;
        for(int i=0; i<(int)size(); ++i)
            str += (*this)[i];

        return str;
    }

};


 /** This function subdivides strings divided by divider in a list of strings.
\return A StringList made of all strings divided by divider.*/
StringList SubdivideString(String str, String divider){
StringList strings; //returned StringList
    strings.clear();    //clear returned stringlist

    int c=0;
	int l=str.size();

    //process entire string
    while(c<l)
	{
        String resultstr;
        resultstr = "";
        //read characters until divider is encountered
        while((str[c]!=divider[0]) && c<l)
		{
            resultstr += str[c];
            c++;
        }

        //Remove spaces \t and \n from string in my implementation...
        //pay attention or change it in dll.h if you don't want to remove
        //a particular char.
        resultstr.trim();//trims string resultstr
        strings.Add(resultstr);//add trimmed string
        c++;
    }

	return strings;
};
