/******************************************************************
 *          Irrlicht screensaver template by Salvatore Russo.     *
 *          Version: 1.0                                          *
 *          License: LGPL                                         *
 *                                                                *
 * This template had been developed and tested with the following *
 * specs:                                                         *
 *  -Irrlicht 0.14.0                                              *
 *  -Microsoft Windows Platform SDK                               *
 *  -Visual C++ Toolkit 2003                                      *
 *  -Codeblocks 1RC2                                              *
 * So before asking check if you meet those requirements, in      *
 * You'd be able to use any other windows compiler that can       *
 * compile Irrlicht, and can use Windows Platform SDK, but I've   *
 * not tested yet, so it's on your own.                           *
 * Just as note, this simple screensaver will show a rotating cube*
 * and it features a fully customisable interface.                *
 * It's built using standard windows API, so please consult       *
 * Microsoft help guide to know more about windows API functions. *
 * Note that if you want to view textured cube you must copy,     *
 * wall.bmp texture in the same dir where your screensaver is, or *
 * specify it's path in configure dialog as media path.           *
 * This is all, so please read carefully the code to understand   *
 * better how this works and remember to add to your project path *
 * Irrlicht and Windows API path to let your project compile.     *
 * If you have troubles not mentioned here, or you need some help *
 * e-mail me at: info@ilbuzzo.net.                                *
 *                                                                *
 * Files contained:                                               *
 *   -irrsaver.cbp -> Codeblocks project file                     *
 *   -main.cpp -> Main file                                       *
 *   -resource.h -> Resource definitions                          *
 *   -support.h -> Some support classes                           *
 *   -dialogs.rc -> Resource file, containing configure dialog    *
 *   -Blank.ico -> Icon used by this screensaver, use yours....   *
 *   -wall.bmp -> the only one texture used by this project       *
 ******************************************************************
*/


#include <windows.h>
#include <scrnsave.h>
#include <irrlicht.h>
#include <commctrl.h>
#include <shlobj.h>

#include "resource.h"
#include "support.h"


#pragma comment(lib,"irrlicht.lib")
#pragma comment ( lib, "scrnsave.lib" )
#pragma comment ( lib, "comctl32.lib" )
#pragma comment(lib,"advapi32.lib")
#pragma comment(lib,"user32.lib")
#pragma comment(lib,"gdi32.lib")
#pragma comment(lib,"kernel32.lib")
#pragma comment(lib,"ole32.lib")
#pragma comment(lib,"shell32.lib")

#pragma comment(linker,"/NODEFAULTLIB:LIBCMT")

//!Some used vars
char buffer[256];
UINT delay;
int fps=0,lastfps=0;

using namespace irr;
using namespace video;
using namespace scene;
using namespace gui;

//!Main Irrlicht pointers
IrrlichtDevice* device;
IVideoDriver *driver;
ISceneManager *smgr;
IGUIEnvironment* guienv;
ICameraSceneNode *camera;
IGUIStaticText *guiconsole;
SIrrlichtCreationParameters params;
ISceneNode *node=0;

//!Variable to mantain state of visualization
static bool preview_mode=false;

//!A structure to store Screensaver preferences
struct prefs
{
    bool AntiAlias;
    video::E_DRIVER_TYPE Driver;
    u32 bits;
    core::dimension2d< s32 > WindowSize;
    UINT fps;
    bool culling;
    bool lights;
    bool goraud;
};
//!Our Preferences
static prefs preferences;

//!Media path
static String Media("");

//!Save your preferences, note that are saved in registry
bool SavePrefs()
{
    //!register key to use
    HKEY hKey;
    char Buffer[2048];
    DWORD dim=2048;
    LONG lRet;
    //!create register Key if not created
    //!else opens it
    lRet=RegCreateKeyEx( HKEY_LOCAL_MACHINE,
               "SOFTWARE\\IrrScreensaver_template",
               0,NULL, REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL, &hKey,NULL );
    //!Note that no control is done on existence or correct
    //!writing of these values
    RegSetValueEx(hKey,"Driver",0,REG_DWORD,(BYTE *)&preferences.Driver,sizeof(preferences.Driver));
    RegSetValueEx(hKey,"Antialias",0,REG_BINARY,(BYTE *)&preferences.AntiAlias,sizeof(preferences.AntiAlias));
    RegSetValueEx(hKey,"Bits",0,REG_DWORD,(BYTE *)&preferences.bits,sizeof(preferences.bits));
    RegSetValueEx(hKey,"Heigth",0,REG_DWORD,(BYTE *)&preferences.WindowSize.Height,sizeof(preferences.WindowSize.Height));
    RegSetValueEx(hKey,"Width",0,REG_DWORD,(BYTE *)&preferences.WindowSize.Width,sizeof(preferences.WindowSize.Width));
    //!Writing String Value
    sprintf(Buffer,"%s",Media.c_str());
    RegSetValueEx(hKey,"Media Path",0,REG_SZ,(BYTE *)Buffer,strlen(Buffer) + 1);

    RegSetValueEx(hKey,"Lighting",0,REG_BINARY,(BYTE *)&preferences.lights,sizeof(preferences.lights));
    RegSetValueEx(hKey,"Culling",0,REG_BINARY,(BYTE *)&preferences.culling,sizeof(preferences.culling));
    RegSetValueEx(hKey,"Goraud",0,REG_BINARY,(BYTE *)&preferences.goraud,sizeof(preferences.goraud));
    RegSetValueEx(hKey,"Delay",0,REG_DWORD,(BYTE *)&preferences.fps,sizeof(preferences.fps));
    RegFlushKey(hKey);
    RegCloseKey(hKey);
    return true;
};

//!Load your preferences, note that are loaded from registry
bool LoadPrefs()
{
    //!register key to use
    HKEY hKey;
    char Buffer[2048];
    DWORD dim=2048;
    DWORD type;
    LONG lRet;
    //!open Registry Key
    lRet=RegOpenKeyEx( HKEY_LOCAL_MACHINE,
               "SOFTWARE\\IrrScreensaver_template",
               0, KEY_QUERY_VALUE, &hKey );
    //!if register key not present create some defaults value and save
    if(lRet!=ERROR_SUCCESS){
     preferences.AntiAlias=false;
     preferences.Driver=irr::video::EDT_SOFTWARE2;
     preferences.WindowSize=core::dimension2d<s32>(320,240);
     preferences.bits=16;
     preferences.fps=10;
     Media=String("");
     preferences.culling=true;
     preferences.lights=false;
     preferences.goraud=true;
     SavePrefs();
     }
    else //!Registry Key exists, so load prefs
    {
    //!get media path
    lRet=RegQueryValueEx(hKey,"Media Path",NULL,NULL,(LPBYTE)Buffer,&dim);
    Media=String(Buffer);
    //!get antialias
    dim=sizeof(preferences.AntiAlias);
    lRet=RegQueryValueEx(hKey,"Antialias",NULL,&type,(LPBYTE)&preferences.AntiAlias,&dim);
    //!get driver
    dim=sizeof(preferences.Driver);
    lRet=RegQueryValueEx(hKey,"Driver",NULL,&type,(LPBYTE)&preferences.Driver,&dim);
    //!get windows sise
    dim=sizeof(preferences.WindowSize.Width);
    lRet=RegQueryValueEx(hKey,"Width",NULL,&type,(LPBYTE)&preferences.WindowSize.Width,&dim);
    dim=sizeof(preferences.WindowSize.Height);
    lRet=RegQueryValueEx(hKey,"Heigth",NULL,&type,(LPBYTE)&preferences.WindowSize.Height,&dim);
    //!get bits per pixel
    dim=sizeof(preferences.bits);
    lRet=RegQueryValueEx(hKey,"Bits",NULL,&type,(LPBYTE)&preferences.bits,&dim);
    //!get delay
    dim=sizeof(preferences.fps);
    lRet=RegQueryValueEx(hKey,"Delay",NULL,&type,(LPBYTE)&preferences.fps,&dim);
    //!get culling
    dim=sizeof(preferences.culling);
    lRet=RegQueryValueEx(hKey,"Culling",NULL,&type,(LPBYTE)&preferences.culling,&dim);
    //!get ligthing
    dim=sizeof(preferences.lights);
    lRet=RegQueryValueEx(hKey,"Ligthing",NULL,&type,(LPBYTE)&preferences.lights,&dim);
    //!get goraud
    dim=sizeof(preferences.goraud);
    lRet=RegQueryValueEx(hKey,"Goraud",NULL,&type,(LPBYTE)&preferences.goraud,&dim);
    }

    return true;
};


//!Main Screen Saver Procedure, this function does all the job
LRESULT WINAPI ScreenSaverProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    static HDC hdc;
    static unsigned int timer;
    static int X = 0, Y = 0;
    static HBRUSH hBlkBrush;
    char commandline[512];
    LPSTR test=commandline;
    StringList parameters;


    //!Let's Create Main message Loop
    switch(message)
    {
        //!When we create this object we do some initialization
        //!and we create Irrlicht device
        case WM_CREATE:
        BOOL val;
        //!Check if a screensaver is running
        SystemParametersInfo(SPI_GETSCREENSAVERRUNNING,
                          0,
                          &val,
                          0);
        //!If a screensaver is running just exit
        if(val) return 0;

        //! Just introduced if you want to know what are the parameters
        //! Passed in a regular call to screensaver
        test=GetCommandLine();
        parameters=SubdivideString(String(test)," ");

        //!Load Preferences from registry
        LoadPrefs();

        //!delay of main loop
        delay=preferences.fps;

        //!Understand what mode you're running screensaver
        //!preview or fullscreen
        if(parameters[1]==String("/p") || parameters[1]==String("/P") || parameters[1]==String("-P") || parameters[1]==String("-p")) preview_mode=true;
        if(parameters[1]==String("/s") || parameters[1]==String("/S") || parameters[1]==String("-S") || parameters[1]==String("-s")) preview_mode=false;

        //!Get a Black brush
        hBlkBrush = (HBRUSH) GetStockObject(BLACK_BRUSH);

        //!Set Device Parameters and then create Irrlicht Device
        params=SIrrlichtCreationParameters();
        params.DriverType=preferences.Driver;
        params.WindowSize=preferences.WindowSize;
        params.Fullscreen=true;
        params.Bits=preferences.bits;
        params.AntiAlias=preferences.AntiAlias;
        params.WindowId=reinterpret_cast<s32>(hwnd);
        device=irr::createDeviceEx  ( params);

        //!Let's init our scene if device exists
        if(device)
        {
            //!Get reference to main Irrlicht Managers
            driver = device->getVideoDriver();
            smgr = device->getSceneManager();
            guienv = device->getGUIEnvironment();

            //!!Add a simple test scene node
            node=smgr->addTestSceneNode(15);

            //!Add a simple Camera
            camera=smgr->addCameraSceneNode();
            camera->setPosition(node->getPosition()+core::vector3df(-30.0f,15.0f,-30.0f));
            camera->setTarget(node->getPosition());

            //!Add a simple Console to show Irrlicht stats
            guiconsole=guienv->addStaticText(  L"",core::rect<int>(10, 10,120,60),true,true,0,-1,true)  ;
            guiconsole->setVisible  (true) ;

            //!Try to texture this node it a texture is found
            if(node){
                ITexture *cube_text=driver->getTexture((Media+String("wall.bmp")).c_str());
                if(cube_text) node->setMaterialTexture(0,cube_text);
                //!Let's set some other preferences
                node->setMaterialFlag(EMF_GOURAUD_SHADING, preferences.goraud);
                node->setMaterialFlag(EMF_BACK_FACE_CULLING, preferences.culling);
                node->setMaterialFlag(EMF_LIGHTING, preferences.lights);
                }
        }
        //!Create a new timer to update screen
        timer = (UINT) SetTimer(hwnd, 1, delay, NULL);
        break;

        //!Here we'll do main Irrlicht loop
        case WM_TIMER:
        //!Let's Rotate our cube a little
        node->setRotation(node->getRotation()+core::vector3df(0.1f,0.2f,0.3f));
        //!Let's Run Irrlicht Device
        device->run();
        driver->beginScene(true, true, SColor(255,6,13,25));
        smgr->drawAll();
        guienv->drawAll();
        driver->endScene();
        //!Print some infos
        fps = driver->getFPS();
        if(lastfps!=fps)
        {
            lastfps=fps;
            core::stringw str;
            if(params.DriverType==irr::video::EDT_DIRECT3D9)
                str=L"Irrlicht Template ScreenSaver 1.0 - DirectX 9.0c";
            if(params.DriverType==irr::video::EDT_OPENGL)
                str=L"Irrlicht Template ScreenSaver 1.0 - OpenGl";
            if(params.DriverType==irr::video::EDT_DIRECT3D8)
                str=L"Irrlicht Template ScreenSaver 1.0 - DirectX 8.1";
            if(params.DriverType==irr::video::EDT_SOFTWARE)
                str=L"Irrlicht Template ScreenSaver 1.0 - Software";
            if(params.DriverType==irr::video::EDT_SOFTWARE2)
                str=L"Irrlicht Template ScreenSaver 1.0 - Software2";
            if(params.DriverType==irr::video::EDT_NULL)
                str=L"Irrlicht Template ScreenSaver 1.0 - Null driver";
            str += "\nFPS:";
            str += fps;
            str +=" Actual delay:";
            str +=(int) delay;
            if(preview_mode) str+="\n Preview Mode";
            else str+="\n FullScreen Mode";
            str +="\n Created by Salvatore Russo";
            guiconsole->setText(str.c_str());

    }
        break;

        //!Kill Timer on Destroy
        case WM_DESTROY:
        if(timer) KillTimer(hwnd, timer);
        break;
        //!Process unhandled messages with default function
        default:
        return DefScreenSaverProc(hwnd, message, wParam, lParam);
    }

    return 0;
}

//!Configure Dialog main function
BOOL WINAPI ScreenSaverConfigureDialog(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    //!Some temp values, note that resolution is not really applied
    //!but bits per pixel are.
    int cursel;
    int len;
    StringList resolution;
    BROWSEINFO browse;
    char buffer[2048];
    switch(message)
    {
        case WM_INITDIALOG:
        //!Needed for some functions
        CoInitialize(NULL);
        //!Load Preferences if any
        LoadPrefs();
        //!Set Up Resolution combobox
        SendMessage(   GetDlgItem( hwnd,IDC_WINSIZE) ,(UINT) CB_INSERTSTRING,      (WPARAM) 0,(LPARAM) "320x240x16");
        SendMessage(   GetDlgItem( hwnd,IDC_WINSIZE) ,(UINT) CB_INSERTSTRING,      (WPARAM) 0,(LPARAM) "640x480x16");
        SendMessage(   GetDlgItem( hwnd,IDC_WINSIZE) ,(UINT) CB_INSERTSTRING,      (WPARAM) 0,(LPARAM) "800x600x16");
        SendMessage(   GetDlgItem( hwnd,IDC_WINSIZE) ,(UINT) CB_INSERTSTRING,      (WPARAM) 0,(LPARAM) "1024x768x16");
        SendMessage(   GetDlgItem( hwnd,IDC_WINSIZE) ,(UINT) CB_INSERTSTRING,      (WPARAM) 0,(LPARAM) "1280x1024x16");
        SendMessage(   GetDlgItem( hwnd,IDC_WINSIZE) ,(UINT) CB_INSERTSTRING,      (WPARAM) 0,(LPARAM) "320x240x32");
        SendMessage(   GetDlgItem( hwnd,IDC_WINSIZE) ,(UINT) CB_INSERTSTRING,      (WPARAM) 0,(LPARAM) "640x480x32");
        SendMessage(   GetDlgItem( hwnd,IDC_WINSIZE) ,(UINT) CB_INSERTSTRING,      (WPARAM) 0,(LPARAM) "800x600x32");
        SendMessage(   GetDlgItem( hwnd,IDC_WINSIZE) ,(UINT) CB_INSERTSTRING,      (WPARAM) 0,(LPARAM) "1024x768x32");
        SendMessage(   GetDlgItem( hwnd,IDC_WINSIZE) ,(UINT) CB_INSERTSTRING,      (WPARAM) 0,(LPARAM) "1280x1024x32");
        //!Set current Resolution
        sprintf(buffer,"%dx%dx%d",preferences.WindowSize.Width,preferences.WindowSize.Height,preferences.bits);
        cursel=SendMessage( GetDlgItem( hwnd,IDC_WINSIZE),(UINT) CB_FINDSTRINGEXACT,(WPARAM) -1,(LPARAM) buffer);
        SendMessage(   GetDlgItem( hwnd,IDC_WINSIZE), (UINT) CB_SETCURSEL,      (WPARAM) cursel,(LPARAM) 0);

        //!Set Up Driver Choosing combobox
        SendMessage(   GetDlgItem( hwnd,IDC_DRIVER) ,(UINT) CB_INSERTSTRING,      (WPARAM) 0,(LPARAM) "NULL");
        SendMessage(   GetDlgItem( hwnd,IDC_DRIVER) ,(UINT) CB_INSERTSTRING,      (WPARAM) 1,(LPARAM) "SOFTWARE");
        SendMessage(   GetDlgItem( hwnd,IDC_DRIVER) ,(UINT) CB_INSERTSTRING,      (WPARAM) 2,(LPARAM) "SOFTWARE2");
        SendMessage(   GetDlgItem( hwnd,IDC_DRIVER) ,(UINT) CB_INSERTSTRING,      (WPARAM) 3,(LPARAM) "DIRECTX8");
        SendMessage(   GetDlgItem( hwnd,IDC_DRIVER) ,(UINT) CB_INSERTSTRING,      (WPARAM) 4,(LPARAM) "DIRECTX9");
        SendMessage(   GetDlgItem( hwnd,IDC_DRIVER) ,(UINT) CB_INSERTSTRING,      (WPARAM) 5,(LPARAM) "OPENGL");
        //!Set current Driver choosed value
        SendMessage(   GetDlgItem( hwnd,IDC_DRIVER), (UINT) CB_SETCURSEL,      (WPARAM) preferences.Driver,(LPARAM) 0);

        //!Set up antialias
        if(preferences.AntiAlias)
            CheckDlgButton(hwnd, IDC_ANALIAS, BST_CHECKED);
        else
            CheckDlgButton(hwnd, IDC_ANALIAS, BST_UNCHECKED);

        //!Set up lighting
        if(preferences.lights)
        CheckDlgButton(hwnd, IDC_LIGHTS, BST_CHECKED);
        else
            CheckDlgButton(hwnd, IDC_LIGHTS, BST_UNCHECKED);

        //!Set up culling
        if(preferences.culling)
        CheckDlgButton(hwnd, IDC_CULLING, BST_CHECKED);
        else
            CheckDlgButton(hwnd, IDC_CULLING, BST_UNCHECKED);

        //!Set up goraud shading
        if(preferences.goraud)
        CheckDlgButton(hwnd, IDC_GORAUD, BST_CHECKED);
        else
            CheckDlgButton(hwnd, IDC_GORAUD, BST_UNCHECKED);

        //!Set Up Delay time in milliseconds
        SendMessage(GetDlgItem( hwnd,IDC_FPS),(UINT) TBM_SETRANGE,(WPARAM) TRUE,(LPARAM) MAKELONG (1, 100));
        SendMessage(GetDlgItem( hwnd,IDC_FPS),(UINT) TBM_SETPOS, (WPARAM) TRUE,(LPARAM) preferences.fps);
        SendMessage(GetDlgItem( hwnd,IDC_FPS), (UINT) TBM_SETTICFREQ,(WPARAM) (WORD) 10,    (LPARAM) 0);
        sprintf(buffer,"%d",preferences.fps);
        SetDlgItemText(hwnd,IDC_FPS_TXT,buffer);

        //!Set Up Media directory
        SetDlgItemText(hwnd,IDC_MEDTXT,Media.c_str());
        //!ended init
        return TRUE;

        //!If Scrolling delay bar
        case WM_HSCROLL  :
        switch(LOWORD(wParam))
        {
            case TB_ENDTRACK:
            case TB_THUMBTRACK:
            case TB_LINEDOWN:
            case TB_LINEUP:
            //!Set Delay
            preferences.fps=SendMessage(GetDlgItem( hwnd,IDC_FPS),(UINT) TBM_GETPOS, (WPARAM) 0,(LPARAM)0);
            sprintf(buffer,"%d",preferences.fps);
            SetDlgItemText(hwnd,IDC_FPS_TXT,buffer);
            break;
            default:
            break;
        }
        break;

        //!If setting other values
        case WM_COMMAND:
        switch(LOWORD(wParam))
        {
            //!Antialiasing
            case IDC_ANALIAS:
            if(IsDlgButtonChecked( hwnd,IDC_ANALIAS)==BST_CHECKED)
                preferences.AntiAlias=true;
            else
                preferences.AntiAlias=false;
            break;
            //!BackFace Culling
            case IDC_CULLING:
            if(IsDlgButtonChecked( hwnd,IDC_CULLING)==BST_CHECKED)
                preferences.culling=true;
            else
                preferences.culling=false;
            break;
            //!Lighting
            case IDC_LIGHTS:
            if(IsDlgButtonChecked( hwnd,IDC_LIGHTS)==BST_CHECKED)
                preferences.lights=true;
            else
                preferences.lights=false;
            break;
            //!Goraud Shading
            case IDC_GORAUD:
            if(IsDlgButtonChecked( hwnd,IDC_GORAUD)==BST_CHECKED)
                preferences.goraud=true;
            else
                preferences.goraud=false;
            break;
            //!Window size, not really used, just bpp used
            case IDC_WINSIZE:
            if(HIWORD(wParam)==CBN_SELCHANGE)
            {
                cursel = SendMessage(GetDlgItem( hwnd,IDC_WINSIZE),(UINT) CB_GETCURSEL,(WPARAM) 0,(LPARAM)0);
                len =  SendMessage(GetDlgItem( hwnd,IDC_WINSIZE),(UINT) CB_GETLBTEXTLEN,(WPARAM) cursel, (LPARAM) 0);
                SendMessage(GetDlgItem( hwnd,IDC_WINSIZE),(UINT) CB_GETLBTEXT,(WPARAM) cursel, (LPARAM) buffer);
                buffer[len]='\0';
                resolution=SubdivideString(String(buffer),String("x"));
                preferences.WindowSize.Height=atoi(resolution[1].c_str());
                preferences.WindowSize.Width=atoi(resolution[0].c_str());
                preferences.bits=atoi(resolution[2].c_str());
            }
            break;
            //!Driver to use
            case IDC_DRIVER:
            if(HIWORD(wParam)==CBN_SELCHANGE)
            {
                cursel = SendMessage(GetDlgItem( hwnd,IDC_DRIVER),(UINT) CB_GETCURSEL,(WPARAM) 0,(LPARAM)0);
                preferences.Driver=(irr::video::E_DRIVER_TYPE)cursel;
            }
            break;
            //!Media path if you intend to not copy all your media
            //!to system32 dir (I suggest you to not copy media in
            //!system dir), so you need just Irrlicht.dll and
            //!this irrsaver.scr in system32 directory.
            case IDC_MEDPATH:
            ZeroMemory(&browse, sizeof(browse));
            browse.pszDisplayName=buffer;
            browse.lpszTitle="Choose Media Directory:";
            browse.ulFlags=BIF_NEWDIALOGSTYLE;
            if(SHGetPathFromIDList( SHBrowseForFolder(&browse),buffer)){
            SetDlgItemText(hwnd,IDC_MEDTXT,buffer);
            Media=String(buffer)+String("\\");
            }
            break;
            //!Clicked OK
            case IDOK:
            SavePrefs();
            EndDialog(hwnd, LOWORD(wParam) == IDOK);
            return TRUE;
            //!Clicked Cancel
            case IDCANCEL:
            EndDialog(hwnd, LOWORD(wParam) == IDCANCEL);
            return TRUE;
        }
        break;
    }
    return FALSE;
}

//!no class to register
BOOL WINAPI RegisterDialogClasses(HANDLE hInst)
{
    return 1;
}
