// Copyright (C) 2002-2007 Nikolaus Gebhardt
// This file is part of the "Irrlicht Engine".
// For conditions of distribution and use, see copyright notice in irrlicht.h
//
// This file was originally written by Salvatore Russo.
// I (Nikolaus Gebhardt) did some minor modifications changes to it and integrated
// it into Irrlicht:
// - removed STL dependency
// - removed log file and replaced it with irrlicht logging
// - adapted code formatting a bit to Irrlicht style
// - removed memory leaks
// Thanks a lot to Salvatore for his work on this and that he gave me
// his permission to add it into Irrlicht.

// This support library has been made by Salvatore Russo and is released under GNU public license for general uses.
// For uses in Irrlicht core and only for Irrlicht related uses I release this library under zlib license.
// It uses standard template libraries to create String class and StringList class used in DeleD
// plugins made by me.

#ifndef __DXS_SUPPORT_H_INCLUDED__
#define __DXS_SUPPORT_H_INCLUDED__

using namespace irr;
using namespace video;

#include "irrString.h"
/** A standard string.
A standard string created with standard template libraries.*/
typedef core::stringc stdstring;
typedef core::stringc String;

//Define a class StringList based on core::array and the defined class String
/** A simple stringlist class based on core::array.
This StringList class is based on core::array and the defined String class.
*/
class StringList : public core::array<String>

{
public:

    /**Basic Constructor*/
    StringList()
	{
	}

    /**Constructor based on file loading.
    Look at LoadFromFile specifications.*/
	StringList(io::IReadFile* file)
	{
		LoadFromFile(file);
	}

    /**Basic destructor.*/
    ~StringList()
	{
		clear();
	}

    //Adds a String to StringList
    /** Add a string to this StringList.*/
    void Add(String str/*<String to add to the current StringList*/)
	{
		push_back(str);
	}

    //Loads a stringlist from a file
    //note that each String added to StringList
    //is separed by a \\n character and it's present
    //at the end of line.
    /** Loads a StringList from a file.
    This function loads a StringList from a file where each string is divided by a \\n char.*/
    void LoadFromFile(io::IReadFile* file)
	{
		int sz = file->getSize();
		char* buf = new char[sz+1];
		file->read(buf, sz);
		buf[sz] = 0;
		char* p = buf;
		char* start = p;

		while(*p)
		{
			if (*p == '\n')
			{
				core::stringc str(start, p - start - 1);
				str.trim();
				Add(str);
				start = p+1;
			}

			++p;
		}

		if (p - start > 1)
		{
			core::stringc str(start, p - start - 1);
			str.trim();
			Add(str);
		}

		delete [] buf;
    }
};

  //This function subdivides a string in a list of strings
/** This function subdivides strings divided by divider in a list of strings.
    used and included in dmfsupport.h yet,so just a declaration.
\return A StringList made of all strings divided by divider.*/
#ifndef DXS_EXTERNAL
StringList SubdivideString(String str, String divider);
#else
StringList SubdivideString(String str, String divider)
{
    StringList strings; //returned StringList
    strings.clear();    //clear returned stringlist

    int c=0;
	int l=str.size();

    //process entire string
    while(c<l)
	{
        String resultstr;
        resultstr = "";
        //read characters until divider is encountered
        while((str[c]!=divider[0]) && c<l)
		{
            resultstr += str[c];
            c++;
        }

        //Remove spaces \t and \n from string in my implementation...
        //pay attention or change it in dll.h if you don't want to remove
        //a particular char.
        resultstr.trim();//trims string resultstr
        strings.Add(resultstr);//add trimmed string
        c++;
    }

	return strings;
}
#endif
#endif