#ifdef DXS_EXTERNAL
#ifndef _C_DXS_PARAMETER_H_INCLUDED
#define _C_DXS_PARAMETER_H_INCLUDED
namespace irr
{
namespace scene
{
    //! Name of the parameter for changing the texture path of the built-in DXS loader.
	/** Use it like this:
	 \code
	 SceneManager->getStringParameters()->setAttribute(
	   scene::DXS_TEXTURE_PATH, "path/to/your/textures");
	\endcode
	**/
	const c8* const DXS_TEXTURE_PATH = "DXS_TexturePath";

	//! Name of the parameter for preserving DMF textures dir structure with built-in DMF loader.
	/** Use it like this:
	 \code
	 //this way you won't use this setting
	 SceneManager->getParameters()->setAttribute(
	   scene::DXS_USE_MATERIALS_DIRS, false);
	 \endcode
	 \code
     //this way you'll use this setting
     SceneManager->getParameters()->setAttribute(
	   scene::DXS_USE_MATERIALS_DIRS, true);
	\endcode
	**/
	const c8* const DXS_USE_MATERIALS_DIRS = "DXS_MaterialsDir";

	//! Name of the parameter for setting reference value of alpha in transparent materials.
	/** Use it like this:
	 \code
	 //this way you'll set alpha ref to 0.1
     SceneManager->getParameters()->setAttribute(
	   scene::DXS_ALPHA_CHANNEL_REF, 0.1);
	\endcode
	**/
	const c8* const DXS_ALPHA_CHANNEL_REF = "DXS_AlphaRef";

	//! Name of the parameter for choose to flip or not tga files.
	/** Use it like this:
	 \code
	 //this way you'll choose to flip alpha textures
     SceneManager->()->setAttribute(
	   scene::DXS_FLIP_ALPHA_TEXTURES, true);
	\endcode
	**/
	const c8* const DXS_FLIP_ALPHA_TEXTURES = "DXS_FlipAlpha";

	//! Name of the parameter for choose to add all scene node as an octTree.
	/** Use it like this:
	 \code
	 //this way you'll choose to add all node as octTree
     SceneManager->()->setAttribute(
	   scene::DXS_LOAD_AS_OCTREE, true);
	\endcode
	**/
	const c8* const DXS_LOAD_AS_OCTTREE = "DXS_LoadAsOCT";

	//! Name of the parameter for choose name of DeleD scene root node.
	/** Use it like this:
	 \code
	 //this way you'll choose DeleD root node name
     SceneManager->()->setAttribute(
	   scene::DXS_ROOT_NODE_NAME, true);
	\endcode
	**/
	const c8* const DXS_ROOT_NODE_NAME = "DXS_ParentName";
	} // end namespace scene
} // end namespace irr
#endif
#endif