/*
  CDXSLoader by Salvatore Russo
  Version 1.1

  This loader is used to load DXS files in Irrlicht.
  Look at the documentation for a sample application.

  Parts of this code are from Irrlicht's CQ3LevelMesh, C3DSMeshFileLoader and CColladaFileLoader
  and are Copyright (C) 2002-2004 Nikolaus Gebhardt.

  Parts of this code are from Murphy McCauley COCTLoader just like GetFaceNormal() or indexes
  creation routines and a routine to add faces. So please refer to COCTLoader.h to know more
  about rights granted.

  You can use this software as you wish but you must not remove these notes about license nor
  credits to others for parts of this code.
*/

#ifndef __C_DXS_LOADER_H_INCLUDED__
#define __C_DXS_LOADER_H_INCLUDED__

#include "IMeshLoader.h"
#include "IVideoDriver.h"
#include "SMesh.h"
#include "ISceneManager.h"
#ifdef DXS_EXTERNAL
#include "CDXSParameters.h"
#endif





namespace irr
{
namespace scene
{
	enum LayerType{
	    COLOR,
	    TEXTURE,
	    LIGHTMAP
	};

	struct SDXSMaterial
	{
		video::SMaterial Mat;
		s32 Id;
		core::stringc Name;
		core::stringc Category;
		core::array<core::stringc> Blend;
		core::array<LayerType> Type;
		s32 LayersNum;
		s32 LightMapNum;
	};

	struct SDXSSettings
	{
		core::stringc scene_name;
		core::stringc scene_author;
		core::stringc scene_comments;
		f32 shadowOpacity;
		video::SColor ambientColor;
	};

	class SDXSVertex
	{
	    public:
	    s32 Id;
	    f32 x;
	    f32 y;
	    f32 z;
	    SDXSVertex(){};
	    f32 *GetPos()
	    {
	        position[0]=x;
	        position[1]=y;
	        position[2]=z;
	        return position;
	    };
	    private:
            f32 position[3];
	};

	struct SDXSUv
	{
	    f32 u;
	    f32 v;
	};

	struct SDXSPoly
	{
	    s32 Mid;
	    core::array<s32> Vid;
	    core::array<SDXSUv> Uv;
	};

	/** A class to load DeleD mesh files.*/
	class CDXSLoader : public IMeshLoader
	{
	public:

		/** constructor*/
		CDXSLoader(video::IVideoDriver* driver, scene::ISceneManager* smgr, io::IFileSystem* fs);

		/** destructor*/
		virtual ~CDXSLoader();

		//! returns true if the file maybe is able to be loaded by this class
		//! based on the file extension (e.g. ".cob")
		virtual bool isALoadableFileExtension(const c8* fileName);

		/** creates/loads an animated mesh from the file.
		 \return Pointer to the created mesh. Returns 0 if loading failed.
		 If you no longer need the mesh, you should call IAnimatedMesh::drop().
		 See IUnknown::drop() for more information.*/
		virtual IAnimatedMesh* createMesh(irr::io::IReadFile* file);


	private:

        void GetFaceNormal(f32 a[3], f32 b[3], f32 c[3], f32 out[3]);

		video::IVideoDriver* Driver;
		scene::ISceneManager* SceneManager;
		io::IFileSystem* FileSystem;
		scene::IAnimatedMesh* DummyMesh;
		core::stringc CurrentlyLoadingMesh;

		core::array<SDXSMaterial> Materials;
		SDXSSettings Settings;

		core::array<SDXSVertex> CurrVertices;
		core::array<SDXSPoly> CurrPolys;
		ISceneNode *parent;


		//! skips an (unknown) section in the document
	void skipSection(io::IXMLReaderUTF8* reader, bool reportSkipping);


	//! reads the scene section and its content
	void readSceneSection(io::IXMLReaderUTF8* reader);

	//! reads the settings section and its content
	void readSettingsSection(io::IXMLReaderUTF8* reader);

	//! reads the materials section and its content
	void readMaterialsSection(io::IXMLReaderUTF8* reader);

    //! reads the category section and its content
	void readCategorySection(io::IXMLReaderUTF8* reader,core::stringc path);

    //! reads the material section and its content
	void readMaterialSection(io::IXMLReaderUTF8* reader,core::stringc category,core::stringc path);

    //! reads the layer section and its content
	void readLayerSection(io::IXMLReaderUTF8* reader,SDXSMaterial *material,core::stringc path);

	//! reads the primitives section and its content
	void readPrimitivesSection(io::IXMLReaderUTF8* reader);

	//! reads the primitive section and its content
	void readPrimitiveSection(io::IXMLReaderUTF8* reader);

	//! reads the vertex section and its content
	void readVertexSection(io::IXMLReaderUTF8* reader);

	//! reads the poly section and its content
	void readPolySection(io::IXMLReaderUTF8* reader);

	//! reads the vertex section inside poly and its content
	void readPolyVertexSection(io::IXMLReaderUTF8* reader,SDXSPoly *poly);

	};

} // end namespace scene
} // end namespace irr

#endif

